#!/bin/bash

echo "Starting Email Relay Service..."

# Function to check if Docker is running
is_docker_running() {
  docker info >/dev/null 2>&1
}

# Check if Docker is running, and start Docker Desktop if not
if ! is_docker_running; then
  echo "Docker is not running. Starting Docker Desktop..."

  # Attempt to start Docker Desktop
  open --background -a Docker


echo "Waiting for Docker to start... please follow on screen instructions in the GUI, you may need to enter your password."
  # Wait for Docker to start
  attempts=0
  max_attempts=20
  while ! is_docker_running; do
    if (( attempts++ == max_attempts )); then
      echo "Docker is not starting. Please open Docker Desktop manually and try again."
      exit 1
    fi
    echo "Waiting for Docker to start..."
    sleep 5
  done
fi

sleep 5
# Run Docker Compose
docker-compose up -d

echo "Email Relay Service started."
