#!/bin/bash

echo "Stopping Email Relay Service..."

# Function to check if Docker is running
is_docker_running() {
  docker info >/dev/null 2>&1
}

# Function to check if the Docker Compose service is running
is_service_running() {
  docker-compose ps | grep -q 'Up'
}

# Start Docker Desktop if it's not running
if ! is_docker_running; then
  echo "Docker is not running. Starting Docker Desktop...(needed to stop the Email Relay Service)"

  # Attempt to start Docker Desktop
  open --background -a Docker

  # Wait for Docker to start
  attempts=0
  max_attempts=10
  while ! is_docker_running; do
    if (( attempts++ == max_attempts )); then
      echo "Docker is not starting. Please open Docker Desktop manually and try again."
      exit 1
    fi
    echo "Waiting for Docker to start..."
    sleep 5
  done
fi

# Check if the Docker Compose service is running
if ! is_service_running; then
  echo "The Email Relay Service is not running. Nothing to stop."
else
  # Stop Docker Compose
  docker-compose down
  echo "Email Relay Service stopped."
fi

# Quit Docker Desktop
echo "Closing Docker Desktop..."
osascript -e 'quit app "Docker Desktop"'

echo "Docker Desktop closed."
